<?php
require "config/db.php"; 
$config = require 'config/config.php';

$data_cadastro = "";
$nome_completo = "";
$ncadastro = $_GET['ncadastro'] ?? null;

if ($ncadastro) {
    $stmt = $conn->prepare("SELECT nome_completo, ncadastro, data_cadastro FROM cadastro WHERE ncadastro = ? LIMIT 1");
    $stmt->bind_param("s", $ncadastro);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        $nome_completo  = $row['nome_completo'];
        $ncadastro      = $row['ncadastro'];
        $data_cadastro      = $row['data_cadastro'];
    }
}


@ini_set( 'display_errors', '1' );
error_reporting( E_ALL );
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>

<!-- Required meta tags -->

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- Links Of CSS File -->

<link rel="stylesheet" href="assets/css/sidebar-menu.css">
<link rel="stylesheet" href="assets/css/simplebar.css">
<link rel="stylesheet" href="assets/css/apexcharts.css">
<link rel="stylesheet" href="assets/css/prism.css">
<link rel="stylesheet" href="assets/css/rangeslider.css">
<link rel="stylesheet" href="assets/css/quill.snow.css">
<link rel="stylesheet" href="assets/css/google-icon.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css">
<link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
<link rel="stylesheet" href="assets/css/fullcalendar.main.css">
<link rel="stylesheet" href="assets/css/jsvectormap.min.css">
<link rel="stylesheet" href="assets/css/lightpick.css">
<link rel="stylesheet" href="assets/css/style.css">

<!-- Favicon -->

<link rel="icon" type="image/png" href="assets/images/favicon.png">

<!-- Title -->

<title>SUCESSO - <?php echo "" . $config['nome_do_sistema'] . ""?> - <?php echo "" . $config['instituicao'] . ""?></title>
</head>

<body class="boxed-size">

<!-- Start Preloader Area -->

<div class="preloader" id="preloader">
  <div class="preloader">
    <div class="waviy position-relative"> <span class="d-inline-block">A</span> <span class="d-inline-block">R</span> <span class="d-inline-block">N</span> <span class="d-inline-block">T</span> <span class="d-inline-block">S</span> <span class="d-inline-block">A</span> <span class="d-inline-block">D</span> <span class="d-inline-block">M</span> </div>
  </div>
</div>

<!-- End Preloader Area --> 

<!-- Start Main Content Area -->

    
    
    <div class="container-fluid min-vh-100 d-flex align-items-center justify-content-center py-5">
  <div class="col-lg-6 col-md-8">
    <div class="card bg-white border-0 rounded-3 shadow-sm p-3">
            <div class="card-body p-4">
            <div class="row g-3 text-center"> 
              
              <!-- Logo -->
                      <div class="mb-4">
          <a href="index.php">
            <img width="115px" height="115px" src="assets/images/logo_rounded.png" alt="logo">
          </a>
        

        <!-- Título -->
        <h4 class="mb-2">CONTA CRIADA - <?php echo $config['nome_do_sistema']; ?> <br>
          <small class="text-muted"><?php echo $config['instituicao']; ?></small>
        </h4>
</div>
              
              <!-- Ícone -->
              <svg class="mb-2 mb-md-3" alt="message" width="140px" height="140px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
                <path fill="#6b74da" d="M584 352C597.3 352 608 362.7 608 376L608 480C608 515.3 579.3 544 544 544L96 544C60.7 544 32 515.3 32 480L32 376C32 362.7 42.7 352 56 352C69.3 352 80 362.7 80 376L80 480C80 488.8 87.2 496 96 496L544 496C552.8 496 560 488.8 560 480L560 376C560 362.7 570.7 352 584 352zM448 96C483.3 96 512 124.7 512 160L512 384C512 419.3 483.3 448 448 448L192 448C156.7 448 128 419.3 128 384L128 160C128 124.7 156.7 96 192 96L448 96zM410.9 180.6C400.2 172.8 385.2 175.2 377.4 185.9L291.8 303.6L265.3 276.2C256.1 266.7 240.9 266.4 231.4 275.6C221.9 284.8 221.6 300 230.8 309.5L277.2 357.5C282.1 362.6 289 365.3 296.1 364.8C303.2 364.3 309.7 360.7 313.9 355L416.2 214.1C424 203.4 421.6 188.4 410.9 180.6z"/>
              </svg>
              
              <!-- Mensagem -->
              <h4 class="fs-30 fw-semibold mb-2">Sucesso!</h4>
              <p class="mb-3 fs-17"> Cadastro realizado com sucesso ✅<br>
                <strong>Nome:</strong> <?php echo htmlspecialchars($nome_completo); ?><br>
                <strong>Data do cadastro:</strong> <?php echo date("d/m/Y H:i:s", strtotime($data_cadastro)); ?><br>
                Você será redirecionado para o pagamento em <strong id="timer">15</strong> segundos... </p>
              
              <!-- Botão --> 
              <a id="btnPagamento" href="pagamento/pix.php?ncadastro=<?php echo urlencode($ncadastro); ?>" class="col-md-4 btn btn-primary fs-20 fw-medium text-dark py-2 px-4 text-white w-100"> Ir para pagamento (20s) </a> </div>
          </div>
    </div>
  </div>
</div>

    
    <script> let seconds = 20; const timerElement = document.getElementById("timer"); const button = document.getElementById("btnPagamento"); const countdown = setInterval(() => { seconds--; timerElement.textContent = seconds; button.textContent = "Ir para pagamento (" + seconds + "s)"; if (seconds <= 0) { clearInterval(countdown); window.location.href = "pix.php"; } }, 1000); </script>


<!-- Start Main Content Area --> 

<!-- Link Of JS File --> 

<!-- Scripts -->   
<script src="config/cep-autofill.js"></script> 
<script src="config/mascaras.js"></script> 
<script src="config/vrifica_campos_form.js"></script> 
<script src="config/feedback_campos_form.js"></script> 
<script src="assets/js/bootstrap.bundle.min.js"></script>

<!-- Scripts para remover --> 
<script src="assets/js/sidebar-menu.js"></script> 
<script src="assets/js/dragdrop.js"></script> 
<script src="assets/js/rangeslider.min.js"></script> 
<script src="assets/js/quill.min.js"></script> 
<script src="assets/js/data-table.js"></script> 
<script src="assets/js/prism.js"></script> 
<script src="assets/js/clipboard.min.js"></script> 
<script src="assets/js/feather.min.js"></script> 
<script src="assets/js/feather.min.js"></script> 
<script src="assets/js/simplebar.min.js"></script> 
<script src="assets/js/apexcharts.min.js"></script> 
<script src="assets/js/echarts.min.js"></script> 
<script src="assets/js/swiper-bundle.min.js"></script> 
<script src="assets/js/fullcalendar.main.js"></script> 
<script src="assets/js/jsvectormap.min.js"></script> 
<script src="assets/js/world-merc.js"></script> 
<script src="assets/js/moment.min.js"></script> 
<script src="assets/js/lightpick.js"></script> 
<script src="assets/js/custom/apexcharts.js"></script> 
<script src="assets/js/custom/echarts.js"></script> 
<script src="assets/js/custom/custom.js"></script>
</body>
</html>