<?php
require "config/db.php";

// ? Definir timezone para Braslia
date_default_timezone_set('America/Sao_Paulo');

// Funo para gerar token seguro --------------------
function gerarToken($id) {
    $chave = "Chave@SistemaCadastro#"; // ?? chave 
    $iv = substr(hash('sha256', $chave), 0, 16);
    $dataHoje = date("Ymd"); // exemplo: 20250909
    $valor = $id . "|" . $dataHoje;

    $cripto = openssl_encrypt($valor, "aes-256-cbc", $chave, 0, $iv);
    $token = rtrim(strtr(base64_encode($cripto), '+/', '-_'), '='); // URL safe

    return $token;
}
// ---------------------------------------------------


// Ativar exceptions do MySQLi
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        // Dados do formulário
        $nome_completo      = $_POST['nome_completo'] ?? null;
        $sexo               = $_POST['sexo'] ?? null;
        $data_nascimento    = $_POST['data_nascimento'] ?? null;
        $estado_civil       = $_POST['estado_civil'] ?? null;
        $nacionalidade      = $_POST['nacionalidade'] ?? null;
        $cpf_cnpj           = $_POST['cpf_cnpj'] ?? null;
        $rg                 = $_POST['rg'] ?? null;
        $nome_mae           = $_POST['nome_mae'] ?? null;
        $nome_pai           = $_POST['nome_pai'] ?? null;

        $telefone_residencial = $_POST['telefone_residencial'] ?? null;
        $telefone_celular     = $_POST['telefone_celular'] ?? null;
        $telefone_emergencia  = $_POST['telefone_emergencia'] ?? null;
        $email_principal      = $_POST['email_principal'] ?? null;

        $cep          = $_POST['cep'] ?? null;
        $logradouro   = $_POST['logradouro'] ?? null;
        $numero       = $_POST['numero'] ?? null;
        $complemento  = $_POST['complemento'] ?? null;
        $bairro       = $_POST['bairro'] ?? null;
        $cidade       = $_POST['cidade'] ?? null;
        $estado       = $_POST['estado'] ?? null;

        $termos_condicoes = $_POST['termos_condicoes'] ?? "NAO";

        // 🔎 Verificar se CPF/CNPJ já existe
        $checkCpf = $conn->prepare("SELECT id FROM cadastro WHERE cpf_cnpj = ?");
        $checkCpf->bind_param("s", $cpf_cnpj);
        $checkCpf->execute();
        $checkCpf->store_result();

        if ($checkCpf->num_rows > 0) {
            echo "<script>alert('❌ Este CPF/CNPJ já está cadastrado!'); history.back();</script>";
            exit;
        }
        $checkCpf->close();

        // 🔎 Verificar se Email já existe
        $checkEmail = $conn->prepare("SELECT id FROM cadastro WHERE email_principal = ?");
        $checkEmail->bind_param("s", $email_principal);
        $checkEmail->execute();
        $checkEmail->store_result();

        if ($checkEmail->num_rows > 0) {
            echo "<script>alert('❌ Este e-mail já está cadastrado!'); history.back();</script>";
            exit;
        }
        $checkEmail->close();

        // 🔑 Gerar token seguro
        $token = gerarToken($cpf_cnpj);


        // 🔢 Criar número de cadastro único
        $ncadastro = date('YmdHis');

// ?? Data de cadastro (horrio de Braslia)
$data_cadastro = date('Y-m-d H:i:s');

// SQL de insero
$sql = "INSERT INTO cadastro 
    (nome_completo, sexo, data_nascimento, estado_civil, nacionalidade, cpf_cnpj, rg, nome_mae, nome_pai, 
     telefone_residencial, telefone_celular, telefone_emergencia, email_principal, 
     cep, logradouro, numero, complemento, bairro, cidade, estado, termos_condicoes, token, ncadastro, data_cadastro)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";


$stmt = $conn->prepare($sql);
$stmt->bind_param("ssssssssssssssssssssssss",
    $nome_completo, $sexo, $data_nascimento, $estado_civil, $nacionalidade, $cpf_cnpj, $rg, $nome_mae, $nome_pai,
    $telefone_residencial, $telefone_celular, $telefone_emergencia, $email_principal,
    $cep, $logradouro, $numero, $complemento, $bairro, $cidade, $estado, $termos_condicoes, $token, $ncadastro, $data_cadastro
);

        if ($stmt->execute()) {
            // ✅ Sucesso → redireciona
            header("Location: sucesso.php?ncadastro=" . urlencode($ncadastro));
            exit;
        }

    } catch (Exception $e) {
        echo "<script>alert('⚠️ Erro inesperado: " . addslashes($e->getMessage()) . "'); history.back();</script>";
    }
}
?>
