<?php
@ini_set( 'display_errors', '1' );
error_reporting( E_ALL );
$config = require 'config/config.php';
?>
<!DOCTYPE html>
<html lang="zxx">
    <head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
		<!-- Links Of CSS File -->
		<link rel="stylesheet" href="assets/css/sidebar-menu.css">
		<link rel="stylesheet" href="assets/css/simplebar.css">
		<link rel="stylesheet" href="assets/css/apexcharts.css">
		<link rel="stylesheet" href="assets/css/prism.css">
		<link rel="stylesheet" href="assets/css/rangeslider.css">
        <link rel="stylesheet" href="assets/css/quill.snow.css">
        <link rel="stylesheet" href="assets/css/google-icon.css">
        <link rel="stylesheet" href="assets/css/remixicon.css">
        <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
        <link rel="stylesheet" href="assets/css/fullcalendar.main.css">
        <link rel="stylesheet" href="assets/css/jsvectormap.min.css">
        <link rel="stylesheet" href="assets/css/lightpick.css">
		<link rel="stylesheet" href="assets/css/style.css">
		<!-- Favicon -->
		<link rel="icon" type="image/png" href="assets/images/favicon.png">
		<!-- Title -->
		<title>CADASTRO - <?php echo "" . $config['nome_do_sistema'] . ""?> - <?php echo "" . $config['instituicao'] . ""?></title>
    </head>
    <body class="boxed-size">
        <!-- Start Preloader Area -->
        <div class="preloader" id="preloader">
            <div class="preloader">
                <div class="waviy position-relative">
                    <span class="d-inline-block">A</span>
                    <span class="d-inline-block">R</span>
                    <span class="d-inline-block">N</span>
                    <span class="d-inline-block">T</span>
                    <span class="d-inline-block">S</span>
                    <span class="d-inline-block">A</span>
                    <span class="d-inline-block">D</span>
                    <span class="d-inline-block">M</span>
                </div>
            </div>
        </div>
        <!-- End Preloader Area -->
        <!-- Start Sidebar Area -->
        <div class="sidebar-area" id="sidebar-area">
            <div class="logo position-relative">
                <a href="index.html" class="d-block text-decoration-none position-relative">
                    <img src="assets/images/logo-icon.png" alt="logo-icon">
                    <span class="logo-text fw-bold text-dark">ArntsAdm</span>
                </a>
                <button class="sidebar-burger-menu bg-transparent p-0 border-0 opacity-0 z-n1 position-absolute top-50 end-0 translate-middle-y" id="sidebar-burger-menu">
                    <i data-feather="x"></i>
                </button>
            </div>
            <aside id="layout-menu" class="layout-menu menu-vertical menu active" data-simplebar>
                <ul class="menu-inner">
                    <li class="menu-title small text-uppercase">
                        <span class="menu-title-text">OTHERS</span>
                    </li>
                    <li class="menu-item">
                        <a href="my-profile.html" class="menu-link">
                            <span class="material-symbols-outlined menu-icon">account_circle</span>
                            <span class="title">My Profile</span>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="javascript:void(0);" class="menu-link menu-toggle active">
                            <span class="material-symbols-outlined menu-icon">settings</span>
                            <span class="title">Settings</span>
                        </a>
                        <ul class="menu-sub">
                            <li class="menu-item">
                                <a href="account-settings.html" class="menu-link">
                                    Account Settings
                                </a>
                            </li>
                            <li class="menu-item">
                                <a href="change-password.html" class="menu-link">
                                    Change Password
                                </a>
                            </li>
                            <li class="menu-item">
                                <a href="connections.html" class="menu-link">
                                    Connections
                                </a>
                            </li>
                            <li class="menu-item">
                                <a href="connections.html" class="menu-link">
                                    Connections
                                </a>
                            </li>
                            <li class="menu-item">
                                <a href="privacy-policy.html" class="menu-link">
                                    Privacy Policy
                                </a>
                            </li>
                            <li class="menu-item">
                                <a href="terms-conditions.html" class="menu-link">
                                    Terms & Conditions
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="menu-item">
                        <a href="logout.html" class="menu-link">
                            <span class="material-symbols-outlined menu-icon">logout</span>
                            <span class="title">Logout</span>
                        </a>
                    </li>
                </ul>
            </aside>
        </div>
        <!-- End Sidebar Area -->
        <!-- Start Main Content Area -->
        <div class="container-fluid">
            <div class="main-content d-flex flex-column">
                <!-- Start Header Area -->
                <header class="header-area bg-white mb-4 rounded-bottom-15" id="header-area">
                    <div class="row align-items-center">
                        <div class="col-lg-4 col-sm-6">
                            <div class="left-header-content">
                                <ul class="d-flex align-items-center ps-0 mb-0 list-unstyled justify-content-center justify-content-sm-start">
                                    <li>
                                        <button class="header-burger-menu bg-transparent p-0 border-0" id="header-burger-menu">
                                            <span class="material-symbols-outlined">menu</span>
                                        </button>
                                    </li>
                                    <li>
                                        <form class="src-form position-relative">
                                            <input type="text" class="form-control" placeholder="Search here.....">
                                            <button type="submit" class="src-btn position-absolute top-50 end-0 translate-middle-y bg-transparent p-0 border-0">
                                                <span class="material-symbols-outlined">search</span>
                                            </button>
                                        </form>
                                    </li>
                                    <li>
                                        <div class="dropdown notifications apps">
                                            <button class="btn btn-secondary border-0 p-0 position-relative" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                <span class="material-symbols-outlined">apps</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-lg p-0 border-0 py-4 px-3 max-h-312" data-simplebar>
                                                <div class="notification-menu d-flex flex-wrap justify-content-between gap-4">
                                                    <a href="https://www.figma.com/" target="_blank" class="dropdown-item p-0 text-center">
                                                        <img src="assets/images/figma.svg" class="wh-25" alt="united-states">
                                                        <span>Figma</span>
                                                    </a>
                                                    <a href="https://www.dribbble.com/" target="_blank" class="dropdown-item p-0 text-center">
                                                        <img src="assets/images/dribbble.svg" class="wh-25" alt="united-states">
                                                        <span>Dribbble</span>
                                                    </a>
                                                    <a href="https://www.spotify.com/" target="_blank" class="dropdown-item p-0 text-center">
                                                        <img src="assets/images/spotify.svg" class="wh-25" alt="united-states">
                                                        <span>Spotify</span>
                                                    </a>
                                                    <a href="https://www.github.com/" target="_blank" class="dropdown-item p-0 text-center">
                                                        <img src="assets/images/github.svg" class="wh-25" alt="united-states">
                                                        <span>Github</span>
                                                    </a>
                                                    <a href="https://www.google.com/drive/" target="_blank" class="dropdown-item p-0 text-center">
                                                        <img src="assets/images/gdrive.svg" class="wh-25" alt="united-states">
                                                        <span>GDrive</span>
                                                    </a>
                                                    <a href="https://www.trello.com/" target="_blank" class="dropdown-item p-0 text-center">
                                                        <img src="assets/images/trello.svg" class="wh-25" alt="united-states">
                                                        <span>Trello</span>
                                                    </a>
                                                    <a href="https://www.slak.com/" target="_blank" class="dropdown-item p-0 text-center">
                                                        <img src="assets/images/slak.svg" class="wh-25" alt="united-states">
                                                        <span>Slak</span>
                                                    </a>
                                                    <a href="https://www.pinterest.com/" target="_blank" class="dropdown-item p-0 text-center">
                                                        <img src="assets/images/pinterest.svg" class="wh-25" alt="united-states">
                                                        <span>Pinterest</span>
                                                    </a>
                                                    <a href="https://www.facebook.com/" target="_blank" class="dropdown-item p-0 text-center">
                                                        <img src="assets/images/facebook.svg" class="wh-25" alt="united-states">
                                                        <span>Facebook</span>
                                                    </a>
                                                    <a href="https://www.linkedin.com/" target="_blank" class="dropdown-item p-0 text-center">
                                                        <img src="assets/images/linkedin.svg" class="wh-25" alt="united-states">
                                                        <span>Linkedin</span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-8 col-sm-6">
                            <div class="right-header-content mt-2 mt-sm-0">
                                <ul class="d-flex align-items-center justify-content-center justify-content-sm-end ps-0 mb-0 list-unstyled">
                                    <li class="header-right-item">
                                        <div class="light-dark">
                                            <button class="switch-toggle settings-btn dark-btn p-0 bg-transparent border-0" id="switch-toggle">
                                                <span class="dark"><i class="material-symbols-outlined">light_mode</i></span> 
                                                <span class="light"><i class="material-symbols-outlined">dark_mode</i></span>
                                            </button>
                                        </div>
                                    </li>
                                    <li class="header-right-item">
                                        <div class="dropdown notifications language">
                                            <button class="btn btn-secondary dropdown-toggle border-0 p-0 position-relative" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                <span class="material-symbols-outlined">translate</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-lg p-0 border-0 dropdown-menu-end">
                                                <span class="fw-semibold fs-15 text-secondary title">Choose Language</span>
                                                <div class="max-h-275" data-simplebar>
                                                    <div class="notification-menu">
                                                        <a href="javascript:void(0);" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <img src="assets/images/usa.svg" class="wh-30 rounded-circle" alt="united-states">
                                                                </div>
                                                                <div class="flex-grow-1 ms-2">
                                                                    <span class="text-secondary fw-medium fs-14">English</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="notification-menu">
                                                        <a href="javascript:void(0);" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <img src="assets/images/canada.svg" class="wh-30 rounded-circle" alt="spain">
                                                                </div>
                                                                <div class="flex-grow-1 ms-2">
                                                                    <span class="text-secondary fw-medium fs-14">Canada</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="notification-menu">
                                                        <a href="javascript:void(0);" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <img src="assets/images/germany.svg" class="wh-30 rounded-circle" alt="spain">
                                                                </div>
                                                                <div class="flex-grow-1 ms-2">
                                                                    <span class="text-secondary fw-medium fs-14">Germany</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="notification-menu">
                                                        <a href="javascript:void(0);" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <img src="assets/images/portugal.svg" class="wh-30 rounded-circle" alt="portugal">
                                                                </div>
                                                                <div class="flex-grow-1 ms-2">
                                                                    <span class="text-secondary fw-medium fs-14">Portugal</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="notification-menu mb-0">
                                                        <a href="javascript:void(0);" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <img src="assets/images/spain.svg" class="wh-30 rounded-circle" alt="spain">
                                                                </div>
                                                                <div class="flex-grow-1 ms-2">
                                                                    <span class="text-secondary fw-medium fs-14">Spain</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="header-right-item">
                                        <button class="fullscreen-btn bg-transparent p-0 border-0" id="fullscreen-button">
                                            <i class="material-symbols-outlined text-body">fullscreen</i>
                                        </button>
                                    </li>
                                    <li class="header-right-item">
                                        <div class="dropdown notifications noti">
                                            <button class="btn btn-secondary border-0 p-0 position-relative badge" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                <span class="material-symbols-outlined">notifications</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-lg p-0 border-0 p-0 dropdown-menu-end">
                                                <div class="d-flex justify-content-between align-items-center title">
                                                    <span class="fw-semibold fs-15 text-secondary">Notifications <span class="fw-normal text-body fs-14">(03)</span></span>
                                                    <button class="p-0 m-0 bg-transparent border-0 fs-14 text-primary">Clear All</button>
                                                </div> 
                                                <div class="max-h-217" data-simplebar>
                                                    <div class="notification-menu">
                                                        <a href="notification.html" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <i class="material-symbols-outlined text-primary">sms</i>
                                                                </div>
                                                                <div class="flex-grow-1 ms-3">
                                                                    <p>You have requested to <span class="fw-semibold">withdrawal</span></p>
                                                                    <span class="fs-13">2 hrs ago</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="notification-menu unseen">
                                                        <a href="notification.html" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <i class="material-symbols-outlined text-info">person</i>
                                                                </div>
                                                                <div class="flex-grow-1 ms-3">
                                                                    <p>A new user added in Trezo</p>
                                                                    <span class="fs-13">3 hrs ago</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="notification-menu">
                                                        <a href="notification.html" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <i class="material-symbols-outlined text-success">mark_email_unread</i>
                                                                </div>
                                                                <div class="flex-grow-1 ms-3">
                                                                    <p>You have requested to <span class="fw-semibold">withdrawal</span></p>
                                                                    <span class="fs-13">1 day ago</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="notification-menu">
                                                        <a href="notification.html" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <i class="material-symbols-outlined text-primary">sms</i>
                                                                </div>
                                                                <div class="flex-grow-1 ms-3">
                                                                    <p>You have requested to <span class="fw-semibold">withdrawal</span></p>
                                                                    <span class="fs-13">2 hrs ago</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="notification-menu unseen">
                                                        <a href="notification.html" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <i class="material-symbols-outlined text-info">person</i>
                                                                </div>
                                                                <div class="flex-grow-1 ms-3">
                                                                    <p>A new user added in Trezo</p>
                                                                    <span class="fs-13">3 hrs ago</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="notification-menu">
                                                        <a href="notification.html" class="dropdown-item">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-shrink-0">
                                                                    <i class="material-symbols-outlined text-success">mark_email_unread</i>
                                                                </div>
                                                                <div class="flex-grow-1 ms-3">
                                                                    <p>You have requested to <span class="fw-semibold">withdrawal</span></p>
                                                                    <span class="fs-13">1 day ago</span>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                </div>
                                                <a href="notification.html" class="dropdown-item text-center text-primary d-block view-all fw-medium rounded-bottom-3">
                                                    <span>See All Notifications </span>
                                                </a>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="header-right-item">
                                        <div class="dropdown admin-profile">
                                            <div class="d-xxl-flex align-items-center bg-transparent border-0 text-start p-0 cursor dropdown-toggle" data-bs-toggle="dropdown">
                                                <div class="flex-shrink-0">
                                                    <img class="rounded-circle wh-40 administrator" src="assets/images/administrator.jpg" alt="admin">
                                                </div>
                                                <div class="flex-grow-1 ms-2">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <div class="d-none d-xxl-block">
                                                            <div class="d-flex align-content-center">
                                                                <h3>Olivia</h3>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="dropdown-menu border-0 bg-white dropdown-menu-end">
                                                <div class="d-flex align-items-center info">
                                                    <div class="flex-shrink-0">
                                                        <img class="rounded-circle wh-30 administrator" src="assets/images/administrator.jpg" alt="admin">
                                                    </div>
                                                    <div class="flex-grow-1 ms-2">
                                                        <h3 class="fw-medium">Olivia John</h3>
                                                        <span class="fs-12">Marketing Manager</span>
                                                    </div>
                                                </div>
                                                <ul class="admin-link ps-0 mb-0 list-unstyled">
                                                    <li>
                                                        <a class="dropdown-item admin-item-link d-flex align-items-center text-body" href="my-profile.html">
                                                            <i class="material-symbols-outlined">account_circle</i>
                                                            <span class="ms-2">My Profile</span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item admin-item-link d-flex align-items-center text-body" href="chat.html">
                                                            <i class="material-symbols-outlined">chat</i>
                                                            <span class="ms-2">Messages</span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item admin-item-link d-flex align-items-center text-body" href="to-do-list.html">
                                                            <i class="material-symbols-outlined">format_list_bulleted </i>
                                                            <span class="ms-2">My Task</span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item admin-item-link d-flex align-items-center text-body" href="checkout.html">
                                                            <i class="material-symbols-outlined">credit_card </i>
                                                            <span class="ms-2">Billing</span>
                                                        </a>
                                                    </li>
                                                </ul>
                                                <ul class="admin-link ps-0 mb-0 list-unstyled">
                                                    <li>
                                                        <a class="dropdown-item admin-item-link d-flex align-items-center text-body" href="settings.html">
                                                            <i class="material-symbols-outlined">settings </i>
                                                            <span class="ms-2">Settings</span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item admin-item-link d-flex align-items-center text-body" href="tickets.html">
                                                            <i class="material-symbols-outlined">support</i>
                                                            <span class="ms-2">Support</span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item admin-item-link d-flex align-items-center text-body" href="lock-screen.html">
                                                            <i class="material-symbols-outlined">lock</i>
                                                            <span class="ms-2">Lock Screen</span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item admin-item-link d-flex align-items-center text-body" href="login.html">
                                                            <i class="material-symbols-outlined">logout</i>
                                                            <span class="ms-2">Logout</span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </header>
                <!-- End Header Area -->
                <div class="main-content-container overflow-hidden">
                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="card bg-primary border-0 rounded-3 welcome-box mb-4">
                                <div class="card-body p-4">
                                    <div class="row align-items-center">
                                        <div class="col-lg-8 col-md-8 col-sm-8">
                                            <div class="border-bottom position-relative top-5">
                                                <h3 class="text-white fw-semibold mb-1">Good Morning, <span class="text-danger-div">Olivia!</span></h3>
                                                <p class="text-light">Here's what's happening with your store today.</p>
                                            </div>
                                            <div class="d-flex align-items-center flex-wrap gap-4 gap-xxl-5">
                                                <div class="d-flex align-items-center welcome-status-item">
                                                    <div class="flex-shrink-0">
                                                        <i class="material-symbols-outlined">shopping_bag</i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h5 class="text-white fw-semibold mb-0">86 New orders</h5>
                                                        <p class="text-light">Awaiting processing</p>
                                                    </div>
                                                </div>
                                                <div class="d-flex align-items-center welcome-status-item">
                                                    <div class="flex-shrink-0">
                                                        <i class="material-symbols-outlined icon-bg">chat_error</i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h5 class="text-white fw-semibold mb-0">35 Products</h5>
                                                        <p class="text-light">Out of stock</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4">
                                            <div class="welcome-img text-center text-sm-end mt-4 mt-sm-0">
                                                <img src="assets/images/welcome.png" alt="welcome">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>
                        
                        <div class="col-lg-8">
                            <div class="card bg-white border-0 rounded-3 mb-4">
                                <div class="card-body p-4">
                                    <div class="d-flex justify-content-between align-items-center flex-wrap gap-3 mb-3 mb-lg-30">
                                        <h3 class="mb-0">Total Sales</h3>
                                        <select class="form-select month-select form-control" aria-label="Default select example">
                                            <option selected>Monthly</option>
                                            <option value="1">Weekly</option>
                                            <option value="2">Today</option>
                                            <option value="3">Yearly</option>
                                        </select>
                                    </div>
                                    <div style="margin-bottom: -15px; margin-left: -10px; margin-top: -10px;">
                                        <div id="top_sales"></div> 
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="row justify-content-center">                                
                                <div class="col-md-4 col-lg-12">
                                    <div class="card bg-white border-0 rounded-3 mb-4 stats-box">
                                        <div class="card-body p-4">
                                            <div class="d-flex justify-content-between flex-wrap gap-2">
                                                <div>
                                                    <div class="d-flex">
                                                        <span>Total Revenue</span>
                                                        <span class="count up">+10%</span>
                                                    </div>
                                                    <h3 class="fs-20 mt-1 mb-0">$165,458</h3>
                                                </div>
                                                <span class="fs-12">Last 30 days</span>
                                            </div>
                                            <div style="max-width: 196px; margin: auto; margin-top: -24px; margin-bottom: -15px;">
                                                <div id="total_evenue"></div>
                                            </div>
                                            <ul class="ps-0 mb-0 list-unstyled stats-list">
                                                <li class="d-flex justify-content-between align-items-center">
                                                    <span class="title">Fashion</span>
                                                    <span>75%</span>
                                                </li>
                                                <li class="d-flex justify-content-between align-items-center">
                                                    <span class="title">Others</span>
                                                    <span>25%</span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row justify-content-center">
                        <div class="col-xl-7 col-xxl-7 col-lg-7">
                            <div class="card bg-white border-0 rounded-3 mb-4">
                                <div class="card-body p-4">
                                    <div class="d-flex justify-content-between align-items-center flex-wrap gap-3 mb-3 mb-lg-4">
                                        <h3 class="mb-0">Recent Orders</h3>
                                        <div class="d-flex">
                                            <form class="position-relative table-src-form">
                                                <input type="text" class="form-control" placeholder="Search here">
                                                <i class="material-symbols-outlined position-absolute top-50 start-0 translate-middle-y">search</i>
                                            </form>
                                            <select class="form-select month-select form-control" aria-label="Default select example">
                                                <option selected>Show All</option>
                                                <option value="1">Weekly</option>
                                                <option value="2">Monthly</option>
                                                <option value="3">Yearly</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="default-table-area recent-orders">
                                        <div class="table-responsive">
                                            <table class="table align-middle">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">Order ID</th>
                                                        <th scope="col">Customer</th>
                                                        <th scope="col">Created</th>
                                                        <th scope="col">Total</th>
                                                        <th scope="col">Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>#JAN-2345</td>
                                                        <td>
                                                            <a href="my-profile.html" class="d-flex align-items-center">
                                                                <img src="assets/images/user-1.jpg" class="wh-40 rounded-3" alt="user">
                                                                <div class="ms-2 ps-1">
                                                                    <h6 class="fw-medium fs-14">Sarah Johnson</h6>
                                                                </div>
                                                            </a>
                                                        </td>
                                                        <td>12 Jan, 2024</td>
                                                        <td>$10,490</td>
                                                        <td>
                                                            <span class="badge bg-success bg-opacity-10 text-success p-2 fs-12 fw-normal">Shipped</span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>#JAN-1323</td>
                                                        <td>
                                                            <a href="my-profile.html" class="d-flex align-items-center">
                                                                <img src="assets/images/user-2.jpg" class="wh-40 rounded-3" alt="user">
                                                                <div class="ms-2 ps-1">
                                                                    <h6 class="fw-medium fs-14">Michael Smith</h6>
                                                                </div>
                                                            </a>
                                                        </td>
                                                        <td>08 Jan, 2024</td>
                                                        <td>$6,575</td>
                                                        <td>
                                                            <span class="badge bg-info bg-opacity-10 text-info p-2 fs-12 fw-normal">Confirmed</span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>#DEC-1234</td>
                                                        <td>
                                                            <a href="my-profile.html" class="d-flex align-items-center">
                                                                <img src="assets/images/user-3.jpg" class="wh-40 rounded-3" alt="user">
                                                                <div class="ms-2 ps-1">
                                                                    <h6 class="fw-medium fs-14">Emily Brown</h6>
                                                                </div>
                                                            </a>
                                                        </td>
                                                        <td>13 Dec, 2023</td>
                                                        <td>$12,870</td>
                                                        <td>
                                                            <span class="badge bg-danger bg-opacity-10 text-danger p-2 fs-12 fw-normal">Pending</span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>#DEC-3567</td>
                                                        <td>
                                                            <a href="my-profile.html" class="d-flex align-items-center">
                                                                <img src="assets/images/user-4.jpg" class="wh-40 rounded-3" alt="user">
                                                                <div class="ms-2 ps-1">
                                                                    <h6 class="fw-medium fs-14">Jason Lee</h6>
                                                                </div>
                                                            </a>
                                                        </td>
                                                        <td>05 Dec, 2023</td>
                                                        <td>$7,895</td>
                                                        <td>
                                                            <span class="badge bg-success bg-opacity-10 text-success p-2 fs-12 fw-normal">Shipped</span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>#DEC-1098</td>
                                                        <td>
                                                            <a href="my-profile.html" class="d-flex align-items-center">
                                                                <img src="assets/images/user-5.jpg" class="wh-40 rounded-3" alt="user">
                                                                <div class="ms-2 ps-1">
                                                                    <h6 class="fw-medium fs-14">Ashley Davis</h6>
                                                                </div>
                                                            </a>
                                                        </td>
                                                        <td>01 Dec, 2023</td>
                                                        <td>$4,680</td>
                                                        <td>
                                                            <span class="badge bg-danger bg-opacity-10 text-danger p-2 fs-12 fw-normal">Rejected</span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="d-flex justify-content-center justify-content-sm-between align-items-center text-center flex-wrap gap-2 showing-wrap">
                                            <span class="fs-12 fw-medium">Showing 5 of 30 Results</span>
                                            <nav aria-label="Page navigation example">
                                                <ul class="pagination mb-0 justify-content-center">
                                                    <li class="page-item">
                                                        <a class="page-link icon" href="index.html" aria-label="Previous">
                                                            <i class="material-symbols-outlined">keyboard_arrow_left</i>
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link active" href="index.html">1</a></li>
                                                    <li class="page-item"><a class="page-link" href="index.html">2</a></li>
                                                    <li class="page-item"><a class="page-link" href="index.html">3</a></li>
                                                    <li class="page-item"><a class="page-link" href="index.html">4</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link icon" href="index.html" aria-label="Next">
                                                            <i class="material-symbols-outlined">keyboard_arrow_right</i>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </nav>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-5 col-xxl-5 col-lg-5">
                            <div class="card bg-white border-0 rounded-3 mb-4">
                                <div class="card-body p-4">
                                    <div class="d-flex justify-content-between align-items-center flex-wrap gap-3 mb-3 mb-lg-4">
                                        <h3 class="mb-0">Recent Transactions</h3>
                                        <div class="dropdown action-opt">
                                            <button class="btn bg-transparent p-0" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="more-horizontal"></i>
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end bg-white border box-shadow">
                                                <li>
                                                    <a class="dropdown-item" href="javascript:;">
                                                        <i data-feather="clock"></i>
                                                        Today
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:;">
                                                        <i data-feather="pie-chart"></i>
                                                        Last 7 Days
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:;">
                                                        <i data-feather="rotate-cw"></i>
                                                        Last Month
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:;">
                                                        <i data-feather="calendar"></i>
                                                        Last 1 Year
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:;">
                                                        <i data-feather="bar-chart"></i>
                                                        All Time
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:;">
                                                        <i data-feather="eye"></i>
                                                        View
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:;">
                                                        <i data-feather="trash"></i>
                                                        Delete
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <ul class="ps-0 mb-0 list-unstyled">
                                        <li class="d-flex align-items-center justify-content-between mb-3 pb-3">
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0">
                                                    <i class="material-symbols-outlined icon-circle bg-primary bg-opacity-10 text-primary text-center rounded-circle wh-40 lh-40">credit_card</i>
                                                </div>
                                                <div class="flex-grow-1 ms-2">
                                                    <h6 class="fw-medium fs16 mb-0">Master Card</h6>
                                                    <span class="fs-12">23 Dec 2023 - 3:20 pm</span>
                                                </div>
                                            </div>
                                            <span class="fs-14 fw-medium text-success">+1,520</span>
                                        </li>
                                        <li class="d-flex align-items-center justify-content-between mb-3 pb-3">
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0">
                                                    <i class="material-symbols-outlined icon-circle bg-danger bg-opacity-10 text-danger text-center rounded-circle wh-40 lh-40">redeem</i>
                                                </div>
                                                <div class="flex-grow-1 ms-2">
                                                    <h6 class="fw-medium fs16 mb-0">Paypal</h6>
                                                    <span class="fs-12">23 Dec 2023 - 3:20 pm</span>
                                                </div>
                                            </div>
                                            <span class="fs-14 fw-medium text-danger">-2,250</span>
                                        </li>
                                        <li class="d-flex align-items-center justify-content-between mb-3 pb-3">
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0">
                                                    <i class="material-symbols-outlined icon-circle bg-primary-div bg-opacity-10 text-primary-div text-center rounded-circle wh-40 lh-40">account_balance</i>
                                                </div>
                                                <div class="flex-grow-1 ms-2">
                                                    <h6 class="fw-medium fs16 mb-0">Wise</h6>
                                                    <span class="fs-12">23 Dec 2023 - 3:20 pm</span>
                                                </div>
                                            </div>
                                            <span class="fs-14 fw-medium text-success">+3,560</span>
                                        </li>
                                        <li class="d-flex align-items-center justify-content-between mb-3 pb-3">
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0">
                                                    <i class="material-symbols-outlined icon-circle bg-info bg-opacity-10 text-info text-center rounded-circle wh-40 lh-40">currency_ruble</i>
                                                </div>
                                                <div class="flex-grow-1 ms-2">
                                                    <h6 class="fw-medium fs16 mb-0">Payoneer</h6>
                                                    <span class="fs-12">23 Dec 2023 - 3:20 pm</span>
                                                </div>
                                            </div>
                                            <span class="fs-14 fw-medium text-success">+6,500</span>
                                        </li>
                                        <li class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0">
                                                    <i class="material-symbols-outlined icon-circle bg-primary bg-opacity-10 text-primary text-center rounded-circle wh-40 lh-40">credit_score</i>
                                                </div>
                                                <div class="flex-grow-1 ms-2">
                                                    <h6 class="fw-medium fs16 mb-0">Credit Card</h6>
                                                    <span class="fs-12">23 Dec 2023 - 3:20 pm</span>
                                                </div>
                                            </div>
                                            <span class="fs-14 fw-medium text-danger">+4,320</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex-grow-1"></div>
                <!-- Start Footer Area -->
                <footer class="footer-area bg-white text-center rounded-top-7">
      
                <p class="fs-14">© <span class="text-primary-div"><?php echo "" . $config['nome_do_sistema'] . ""?> versão <?php echo "" . $config['versao'] . ""?></span> é desemvolvido por <a href="https://arantestecnologia.com.br/" target="_blank" class="text-decoration-none text-primary">ARANTES TECNOLOGIA</a></p>
    </footer>
                <!-- End Footer Area -->
            </div>
        </div>
        <!-- Start Main Content Area -->
        <!-- Link Of JS File -->
        <script src="assets/js/bootstrap.bundle.min.js"></script>
        <script src="assets/js/sidebar-menu.js"></script>
        <script src="assets/js/dragdrop.js"></script>
        <script src="assets/js/rangeslider.min.js"></script>
        <script src="assets/js/quill.min.js"></script>
        <script src="assets/js/data-table.js"></script>
        <script src="assets/js/prism.js"></script>
        <script src="assets/js/clipboard.min.js"></script>
        <script src="assets/js/feather.min.js"></script>
        <script src="assets/js/simplebar.min.js"></script>
        <script src="assets/js/apexcharts.min.js"></script>
        <script src="assets/js/echarts.min.js"></script>
        <script src="assets/js/swiper-bundle.min.js"></script>
        <script src="assets/js/fullcalendar.main.js"></script>
        <script src="assets/js/jsvectormap.min.js"></script>
        <script src="assets/js/world-merc.js"></script>
        <script src="assets/js/moment.min.js"></script>
        <script src="assets/js/lightpick.js"></script>
        <script src="assets/js/custom/apexcharts.js"></script>
        <script src="assets/js/custom/echarts.js"></script>
        <script src="assets/js/custom/custom.js"></script>
    </body>
</html>