function limpa_formulario_cep() {
    document.getElementById('logradouro').value = "";
    document.getElementById('bairro').value = "";
    document.getElementById('cidade').value = "";
    document.getElementById('estado').value = "";
}

function meu_callback(conteudo) {
    let cepField = document.getElementById('cep');

    if (!("erro" in conteudo)) {
        document.getElementById('logradouro').value = conteudo.logradouro;
        document.getElementById('bairro').value = conteudo.bairro;
        document.getElementById('cidade').value = conteudo.localidade;
        document.getElementById('estado').value = conteudo.uf;

        cepField.classList.add('is-valid');
        cepField.classList.remove('is-invalid');
    } else {
        limpa_formulario_cep();
        cepField.classList.add('is-invalid');
        cepField.classList.remove('is-valid');
    }
}

function pesquisacep(valor) {
    var cepField = document.getElementById('cep');
    var cep = valor.replace(/\D/g, '');

    if (cep !== "") {
        var validacep = /^[0-9]{8}$/;

        if (validacep.test(cep)) {
            // coloca "..." enquanto consulta
            document.getElementById('logradouro').value = "...";
            document.getElementById('bairro').value = "...";
            document.getElementById('cidade').value = "...";
            document.getElementById('estado').value = "...";

            // limpa feedback anterior
            cepField.classList.remove('is-valid', 'is-invalid');

            // chama API ViaCEP
            var script = document.createElement('script');
            script.src = 'https://viacep.com.br/ws/' + cep + '/json/?callback=meu_callback';
            document.body.appendChild(script);
        } else {
            limpa_formulario_cep();
            cepField.classList.add('is-invalid');
            cepField.classList.remove('is-valid');
        }
    } else {
        limpa_formulario_cep();
        cepField.classList.remove('is-valid', 'is-invalid'); // neutro se vazio
    }
}
