<?php
@ini_set( 'display_errors', '1' );
error_reporting( E_ALL );

$config = require 'config/config.php';
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>

<!-- Required meta tags -->

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- Links Of CSS File -->

<link rel="stylesheet" href="assets/css/sidebar-menu.css">
<link rel="stylesheet" href="assets/css/simplebar.css">
<link rel="stylesheet" href="assets/css/apexcharts.css">
<link rel="stylesheet" href="assets/css/prism.css">
<link rel="stylesheet" href="assets/css/rangeslider.css">
<link rel="stylesheet" href="assets/css/quill.snow.css">
<link rel="stylesheet" href="assets/css/google-icon.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css">
<link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
<link rel="stylesheet" href="assets/css/fullcalendar.main.css">
<link rel="stylesheet" href="assets/css/jsvectormap.min.css">
<link rel="stylesheet" href="assets/css/lightpick.css">
<link rel="stylesheet" href="assets/css/style2.css">

<!-- Favicon -->

<link rel="icon" type="image/png" href="assets/images/favicon.png">

<!-- Title -->

<title>CADASTRO - <?php echo "" . $config['nome_do_sistema'] . ""?> - <?php echo "" . $config['instituicao'] . ""?></title>
</head>

<body class="boxed-size">

<!-- Start Preloader Area -->

<div class="preloader" id="preloader">
  <div class="preloader">
    <div class="waviy position-relative"> <span class="d-inline-block">A</span> <span class="d-inline-block">R</span> <span class="d-inline-block">N</span> <span class="d-inline-block">T</span> <span class="d-inline-block">S</span> <span class="d-inline-block">A</span> <span class="d-inline-block">D</span> <span class="d-inline-block">M</span> </div>
  </div>
</div>

<!-- End Preloader Area --> 

<!-- Start Main Content Area -->

<div class="container-fluid">
  <div class="main-content full-width-content d-inline-flex flex-column"> 
    <!-- Start Header Area -->
    
    <header class="header-area bg-white mb-4 rounded-bottom-15" id="header-area">
      <div class="row align-items-center">
        <div class="col-lg-8 col-sm-8">
          <div class="left-header-content">
            <ul class="d-flex align-items-center ps-0 mb-0 list-unstyled justify-content-center justify-content-sm-start">
              <li><a href="index.php"><img src="assets/images/logo_rounded.png" class="wh-57 rounded-circle  transition-zoom-in me-8" alt="user"></li>
              <li><h2>CADASTRO - <?php echo "" . $config['instituicao'] . ""?></h2></a></li>
            </ul>
          </div>
        </div>
        <div class="col-lg-4 col-sm-4">
          <div class="right-header-content mt-2 mt-sm-0">
            <ul class="d-flex align-items-center justify-content-center justify-content-sm-end ps-0 mb-0 list-unstyled">
              <li class="header-right-item">
                <div class="light-dark">
                  <button class="switch-toggle settings-btn dark-btn p-0 bg-transparent border-0" id="switch-toggle"> <span class="dark"><i class="material-symbols-outlined">light_mode</i> </span> <span class="light"><i class="material-symbols-outlined">dark_mode</i></span> </button>
                </div>
              </li>
              <li class="header-right-item">
                <button class="fullscreen-btn bg-transparent p-0 border-0" id="fullscreen-button"> <i class="material-symbols-outlined text-body">fullscreen</i> </button>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </header>
    
    <!-- End Header Area -->
    <form action="exe_cadastro.php" method="POST" class="needs-validation">
      <div class="row justify-content-center"> 
        <!-- seus inputs aqui -->
        
        <div class="col-lg-2">
              <div class="card bg-white border-0 rounded-3 mb-4">
        <div align="center" class="card-body p-4">
            <img src="assets/images/card-1.jpg" class="mb-4 rounded-3" alt="card">
            <a href="#" class="btn btn-primary py-2 px-4 bg-primary bg-opacity-10 fw-semibold text-primary border-0 hover-bg">Alterar foto</a>
        </div>
    </div>
        </div>
        <div class="col-lg-8">
          <div class="card bg-white border-0 rounded-3 mb-4">
            <div class="card-body p-4">
              <h4 class="fs-18 mb-4">DADOS PESSOAIS</h4>
                  <div class="row g-3"> 
                    
                    <!-- Linha 1 -->
                    <div class="col-md-4">
                      <label for="nome_completo" class="form-label text-secondary">Nome Completo</label>
                      <div class="position-relative">
                        <input type="text" class="form-control h-55 ps-5" id="nome_completo" name="nome_completo" placeholder="Digite seu nome completo" required>
                        <div class="valid-feedback">Tudo certo!</div>
                        <i class="ri-user-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    <div class="col-md-4">
                      <label for="sexo" class="form-label text-secondary">Sexo</label>
                      <div class="position-relative">
                        <select class="form-select form-control h-55 ps-5" id="sexo" name="sexo" required>
                          <option selected disabled value="">Selecionar Sexo</option>
                          <option value="MASCULINO">Masculino</option>
                          <option value="FEMININO">Feminino</option>
                          <option value="OOUTRO">Outro</option>
                        </select>
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, selecione uma opção válida.</div>
                        <i class="ri-user-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                      <div class="col-md-4">
                          <label for="data_nascimento" class="form-label text-secondary">Data de Nascimento</label>
                          <div class="position-relative">
                              <input type="text" class="form-control h-55 ps-5" id="data_nascimento" name="data_nascimento" required placeholder="DD/MM/AAAA" maxlength="10">
                              <div class="valid-feedback">Tudo certo!</div>
                              <div class="invalid-feedback">Preencha uma data completa no formato DD/MM/AAAA.</div>
                              <i class="ri-calendar-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i>
                          </div>
                      </div>

                    
                    <!-- Linha 2 -->
                    <div class="col-md-4">
                      <label for="estado_civil" class="form-label text-secondary">Estado Civil</label>
                      <div class="position-relative">
                        <select class="form-select form-control h-55 ps-5" id="estado_civil" name="estado_civil" required>
                          <option selected disabled value="">Selecionar Estado Civil</option>
                          <option value="SOLTEIRO">Solteiro(a)</option>
                          <option value="CASADO">Casado(a)</option>
                          <option value="SEPARADO">Separado(a)</option>
                          <option value="DIVORCIADO">Divorciado(a)</option>
                          <option value="VIUVO">Viúvo(a)</option>
                          <option value="UNIAO_ESTAVEL">União Estável</option>
                        </select>
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, selecione uma opção válida.</div>
                        <i class="ri-heart-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    <div class="col-md-4">
                      <label for="nacionalidade" class="form-label text-secondary">Nacionalidade</label>
                      <div class="position-relative">
                        <input type="text" class="form-control h-55 ps-5" id="nacionalidade" name="nacionalidade" placeholder="Ex: Brasileira" required>
                        <div class="valid-feedback">Tudo certo!</div>
                        <i class="ri-flag-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    <div class="col-md-4">
                      <label for="cpf_cnpj" class="form-label text-secondary">CPF ou CNPJ</label>
                      <div class="position-relative">
                        <input type="text" class="form-control h-55 ps-5" id="cpf_cnpj" name="cpf_cnpj"
            oninput="mascaraCpfCnpj(this)" onblur="verificaCpfCnpj(this)" maxlength="18"
            placeholder="Digite CPF ou CNPJ" required>
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">CPF ou CNPJ inválido.</div>
                        <i class="ri-id-card-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20"
            style="top: 13px !important;"></i> </div>
                    </div>
                    
                    <!-- Linha 3 -->
                    <div class="col-md-4">
                      <label for="rg" class="form-label text-secondary">RG / Órgão Expeditor</label>
                      <div class="position-relative">
                        <input type="text" class="form-control h-55 ps-5" id="rg" name="rg" placeholder="Digite seu RG e órgão expeditor" required>
                        <div class="valid-feedback">Tudo certo!</div>
                        <i class="ri-file-list-3-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    <div class="col-md-4">
                      <label for="nome_mae" class="form-label text-secondary">Nome da Mãe</label>
                      <div class="position-relative">
                        <input type="text" class="form-control h-55 ps-5" id="nome_mae" name="nome_mae" placeholder="Digite o nome da mãe" required>
                        <div class="valid-feedback">Tudo certo!</div>
                        <i class="ri-user-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    <div class="col-md-4">
                      <label for="nome_pai" class="form-label text-secondary">Nome do Pai</label>
                      <div class="position-relative">
                        <input type="text" class="form-control h-55 ps-5" id="nome_pai" name="nome_pai" placeholder="Digite o nome do pai">
                        <div class="valid-feedback">Tudo certo!</div>
                        <i class="ri-user-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                  </div>
                  <!-- row --> 
            </div>
          </div>
        </div>
        <div class="col-lg-10">
          <div class="card bg-white border-0 rounded-3 mb-4">
            <div class="card-body p-4">
              <h4 class="fs-18 mb-4">DADOS PARA CONTATO</h4>
                  <div class="row g-3"> 
                    
                    <!-- Telefone Residencial -->
                    <div class="col-md-3">
                      <label for="telefone_residencial" class="form-label text-secondary">Telefone Residencial</label>
                      <div class="position-relative">
                        <input type="tel" class="form-control h-55 ps-5" oninput="mascaraTelefoneFixo(this)" onblur="verificaTelefone(this)" maxlength="14" id="telefone_residencial" name="telefone_residencial" placeholder="(00) 0000-0000">
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, insira um telefone válido.</div>
                        <i class="ri-phone-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    
                    <!-- Telefone Celular -->
                    <div class="col-md-3">
                      <label for="telefone_celular" class="form-label text-secondary"> Telefone Celular</label>
                      <div class="position-relative">
                        <input type="tel"  oninput="mascaraCelular(this)" onblur="verificaTelefone(this)" maxlength="15" class="form-control h-55 ps-5" id="telefone_celular" name="telefone_celular" placeholder="(00) 00000-0000" required>
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, insira um telefone celular válido.</div>
                        <i class="ri-smartphone-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    
                    <!-- Telefone para Emergências -->
                    <div class="col-md-3">
                      <label for="telefone_emergencia" class="form-label text-secondary">Telefone para Emergências</label>
                      <div class="position-relative">
                        <input type="tel" class="form-control h-55 ps-5" id="telefone_emergencia" name="telefone_emergencia" placeholder="(00) 00000-0000" maxlength="15"oninput="mascaraTelefone(this)" onblur="verificaTelefone(this)">
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, insira um telefone válido.</div>
                        <i class="ri-phone-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    
                    <!-- Email Principal -->
                    <div class="col-md-3">
                      <label for="email_principal" class="form-label text-secondary"> Email Principal</label>
                      <div class="position-relative">
                        <input type="email" class="form-control h-55 ps-5" id="email_principal" name="email_principal"
            placeholder="email@exemplo.com" required onblur="verificaEmail(this)">
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, insira um email válido.</div>
                        <i class="ri-mail-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20"
            style="top: 13px !important;"></i> </div>
                    </div>
                  </div>
                  <!-- row --> 
                </div>
          </div>
        </div>
        <div class="col-lg-10">
          <div class="card bg-white border-0 rounded-3 mb-4">
            <div class="card-body p-4">
              <h4 class="fs-18 mb-4">ENDEREÇO</h4>
                  <div class="row g-3"> 
                    <!-- CEP -->
                    <div class="col-md-3">
                      <label for="cep" class="form-label text-secondary">CEP</label>
                      <div class="position-relative">
                        <input type="text" oninput="mascaraCEP(this)" maxlength="9" class="form-control h-55 ps-5" id="cep" name="cep" placeholder="00000-000" required onblur="pesquisacep(this.value)">
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, insira um CEP válido.</div>
                        <i class="ri-map-pin-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    
                    <!-- Logradouro -->
                    <div class="col-md-5">
                      <label for="logradouro" class="form-label text-secondary">Logradouro (rua, avenida ...)</label>
                      <div class="position-relative">
                        <input type="text" class="form-control h-55 ps-5" id="logradouro" name="logradouro" placeholder="Digite o logradouro" required>
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, insira o logradouro.</div>
                        <i class="ri-road-map-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    
                    <!-- Número -->
                    <div class="col-md-2">
                      <label for="numero" class="form-label text-secondary">Número</label>
                      <div class="position-relative">
                        <input type="number" class="form-control h-55 ps-5" id="numero" name="numero" placeholder="00" required>
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, insira o número.</div>
                        <i class="ri-hashtag position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    
                    <!-- Complemento -->
                    <div class="col-md-2">
                      <label for="complemento" class="form-label text-secondary">Complemento</label>
                      <div class="position-relative">
                        <input type="text" class="form-control h-55 ps-5" id="complemento" name="complemento" placeholder="Apto, bloco, etc.">
                        <div class="valid-feedback">Tudo certo!</div>
                        <i class="ri-building-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    
                    <!-- Bairro -->
                    <div class="col-md-4">
                      <label for="bairro" class="form-label text-secondary">Bairro</label>
                      <div class="position-relative">
                        <input type="text" class="form-control h-55 ps-5" id="bairro" name="bairro" placeholder="Digite o bairro" required>
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, insira o bairro.</div>
                        <i class="ri-home-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    
                    <!-- Cidade -->
                    <div class="col-md-4">
                      <label for="cidade" class="form-label text-secondary">Cidade</label>
                      <div class="position-relative">
                        <input type="text" class="form-control h-55 ps-5" id="cidade" name="cidade" placeholder="Digite a cidade" required>
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, insira a cidade.</div>
                        <i class="ri-building-2-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                    
                    <!-- Estado -->
                    <div class="col-md-4">
                      <label for="estado" class="form-label text-secondary">Estado</label>
                      <div class="position-relative">
                        <select class="form-select form-control h-55 ps-5" id="estado" name="estado" required>
                          <option selected disabled value="">Selecionar Estado</option>
                          <option value="AC">AC</option>
                          <option value="AL">AL</option>
                          <option value="AP">AP</option>
                          <option value="AM">AM</option>
                          <option value="BA">BA</option>
                          <option value="CE">CE</option>
                          <option value="DF">DF</option>
                          <option value="ES">ES</option>
                          <option value="GO">GO</option>
                          <option value="MA">MA</option>
                          <option value="MT">MT</option>
                          <option value="MS">MS</option>
                          <option value="MG">MG</option>
                          <option value="PA">PA</option>
                          <option value="PB">PB</option>
                          <option value="PR">PR</option>
                          <option value="PE">PE</option>
                          <option value="PI">PI</option>
                          <option value="RJ">RJ</option>
                          <option value="RN">RN</option>
                          <option value="RS">RS</option>
                          <option value="RO">RO</option>
                          <option value="RR">RR</option>
                          <option value="SC">SC</option>
                          <option value="SP">SP</option>
                          <option value="SE">SE</option>
                          <option value="TO">TO</option>
                        </select>
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Por favor, selecione um estado válido.</div>
                        <i class="ri-map-pin-2-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                    </div>
                  </div>
            </div>
          </div>
        </div>
        <div class="col-lg-10">
          <div class="card bg-white border-0 rounded-3 mb-4">
            <div class="card-body p-4">
              <h4 class="fs-18 mb-4">DECLARAÇÃO E ENVIO</h4>
                  <div class="row g-3">
                    <div class="col-12">
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="SIM" id="termos_condicoes" name="termos_condicoes" required>
                        <label class="form-check-label" for="termos_condicoes"> Concordo com os termos e condições.<a data-bs-toggle="modal" data-bs-target="#exampleModallg"><strong><i class="ri-eye-line top-0 start-0 text-gray-light ps-20" style="top: 13px !important;"></i>Termos de Uso e LGPD</strong></a></label>
                        <div class="valid-feedback">Tudo certo!</div>
                        <div class="invalid-feedback">Você deve concordar antes de enviar.</div>
                      </div>
                    </div>
                      <div class="col-12">
                      <button class="btn btn-primary fw-semibold text-white py-2 px-3" type="submit"><i class="ri-send-plane-fill"></i> Enviar Formulário</button>
                    </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </form>
    
    <!-- Modal -->
<div class="modal fade" id="exampleModallg" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Termos de Uso e LGPD</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
            </div>
            <div class="modal-body" style="max-height: 400px; overflow-y: auto;">
                <p>
                    Ao utilizar este sistema, você declara estar ciente e de acordo com os <strong>Termos de Uso</strong> 
                    e com a <strong>Política de Privacidade</strong>, em conformidade com a Lei Geral de Proteção de Dados (Lei nº 13.709/2018 – LGPD).
                </p>
                <p>
                    Os dados coletados poderão incluir informações pessoais necessárias para identificação, cadastro, 
                    autenticação de acesso e prestação de serviços. Esses dados serão utilizados exclusivamente 
                    para finalidades legítimas, respeitando a base legal prevista na LGPD.
                </p>
                <p>
                    Garantimos que suas informações serão tratadas de forma segura e não serão compartilhadas com 
                    terceiros sem o seu consentimento, salvo em casos previstos em lei ou quando necessário para 
                    cumprimento de obrigações legais ou regulatórias.
                </p>
                <p>
                    Ao prosseguir, você concorda com o tratamento de seus dados pessoais conforme descrito acima 
                    e com as demais condições estabelecidas em nossos Termos de Uso e Política de Privacidade.
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger text-white" data-bs-dismiss="modal">Não aceito</button>
                <button type="button" class="btn btn-primary text-white" data-bs-dismiss="modal">Concordo</button>
            </div>
        </div>
    </div>
</div>
    <!-- Start Footer Area -->
    
    <footer class="footer-area bg-white text-center rounded-top-7">
      <p class="fs-14">© <span class="text-primary-div"><?php echo "" . $config['nome_do_sistema'] . ""?> versão <?php echo "" . $config['versao'] . ""?></span> é desemvolvido por <a href="https://arantestecnologia.com.br/" target="_blank" class="text-decoration-none text-primary">ARANTES TECNOLOGIA</a></p>
    </footer>
    
    <!-- End Footer Area --> 
    
  </div>
</div>

<!-- Start Main Content Area --> 

<!-- Link Of JS File --> 

<!-- Scripts -->   
<script src="config/cep-autofill.js"></script> 
<script src="config/mascaras.js"></script> 
<script src="config/vrifica_campos_form.js"></script> 
<script src="config/feedback_campos_form.js"></script> 
<script src="assets/js/bootstrap.bundle.min.js"></script>

<!-- Scripts para remover --> 
<script src="assets/js/sidebar-menu.js"></script> 
<script src="assets/js/dragdrop.js"></script> 
<script src="assets/js/rangeslider.min.js"></script> 
<script src="assets/js/quill.min.js"></script> 
<script src="assets/js/data-table.js"></script> 
<script src="assets/js/prism.js"></script> 
<script src="assets/js/clipboard.min.js"></script> 
<script src="assets/js/feather.min.js"></script> 
<script src="assets/js/feather.min.js"></script> 
<script src="assets/js/simplebar.min.js"></script> 
<script src="assets/js/apexcharts.min.js"></script> 
<script src="assets/js/echarts.min.js"></script> 
<script src="assets/js/swiper-bundle.min.js"></script> 
<script src="assets/js/fullcalendar.main.js"></script> 
<script src="assets/js/jsvectormap.min.js"></script> 
<script src="assets/js/world-merc.js"></script> 
<script src="assets/js/moment.min.js"></script> 
<script src="assets/js/lightpick.js"></script> 
<script src="assets/js/custom/apexcharts.js"></script> 
<script src="assets/js/custom/echarts.js"></script> 
<script src="assets/js/custom/custom.js"></script>
</body>
</html>