<?php
include('../config.php');

// Recebe o ID com segurança
$collector_id = isset($_GET['id']) ? trim($_GET['id']) : null;

if (!$collector_id) {
    die('ID inválido.');
}

// Configuração da API (mova o token para config.php)
$access_token = $config['APP_USR-2436048829893619-100910-55c3c8158a25c7da48cc958cf677ae56-35703420']; // Exemplo de variável configurada

// Faz a chamada para o Mercado Pago
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://api.mercadopago.com/v1/payments/' . urlencode($collector_id),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_HTTPHEADER => [
        'accept: application/json',
        'content-type: application/json',
        'Authorization: Bearer ' . $access_token
    ],
]);

$response = curl_exec($curl);

if (curl_errno($curl)) {
    error_log('Erro CURL: ' . curl_error($curl));
    die('Erro na conexão com Mercado Pago.');
}

$resultado = json_decode($response);
curl_close($curl);

// Verifica se retornou status
if (isset($resultado->status)) {
    $status = mysqli_real_escape_string($conexao, $resultado->status);
    $codigo = mysqli_real_escape_string($conexao, $collector_id);

    $update = "UPDATE status SET status='$status' WHERE codigo='$codigo'";
    mysqli_query($conexao, $update);
} else {
    error_log("Erro ao obter status do pagamento ID: $collector_id. Resposta: $response");
    die('Não foi possível atualizar o status.');
}

?>
